/*------------------------------------------------------------------------------*
 * File Name: OC_types.h														*
 * Creation: CPY 6/5/2001														*
 * Purpose: Origin C typede struct for Origin internal functions				*
 * Copyright (c) OriginLab Corp.	2001										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * LY 6/25/01 Add Origin ODD file format description structure	
 * LAS, 1/31/03 commented out NLSFCntrl; C# using statement now supported: "using NLSF = LabTalk.NLSF" 
 * SY 04-25-2003 QA70-3985 SAVE_TO_SPC_FILE										*
 * JCG 06/06/03 QA70-4540 v7.0598 CENTROID_FOR_INTEGRATE						*
 * DVT 7/9/03 QA70-4801 v7.0621 OC_GET_PAGE_SYSTEM_INFO							*
 * CPY 8/27/03 QA70-5073 ADD_READ_ROWS_TO_ASCII_IMP_STRUCT						*
 * EJP 10-09-2003 v7.5715 QA70-5317 ADD_DATE_FORMAT_TO_ASCIMP_STRUCT			*
 * CPY 10/23/03 v7.5729 QA70-5412	SKIP_CHARS_FOR_COL_NAME_LABEL				*
 * EJP 06-22-2004 v8.0894 QA70-6523 MORE_HEADER_LINE_TYPES						*
 * EJP 07-08-2004 v8.0904 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ						*
 * EJP 09-01-2004 v8.0127 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP					*
 * YuI 11/02/04 V7.5158 QA70-7122 OC_DATA_PLOT_CREATION							*
 * EJP 12-15-2004 v8.0174 QA70-7252 ADD_ID_TO_ASCIMP							*
 * EJP 2005-02-28 v8.0198 QA70-7433 IMPORT_CSV_FILES							*
 * CPY 6/18/05 QA70-7820 DATA_PLOT_INFO_AND_LOOSE_DATASET_SUPPORT				*
 * EJP 2005-06-24 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS			*
 * RVD 8/5/2005 v8.0283 LIMIT_AUTOSIZE_ROWCOL									*
 * EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM							*
 * RVD 10/27/2005 QA70-8233 v8.0325 LEAD_EPRINT									*
 * SY 2006-11-14 v8.0510 SPC_IN_DATASHEET_WITH_TREE								*
 * Cheney 2007-2-6 ADD_OPTION_TO_SUPPORT_SPECIAL_NUM_FORMAT_FOR_ASCIMP			*
 * Sim 2-25-07 ADD_FILE_PATH_OPTION_FOR_RENAME_WORKBOOK							*
 * Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE					*
 *	CPY 3/23/07 QA70-8500 IMPORT_KEEP_COLS_SAME_LENGTH_SHOULD_BE_AN_OPTION		*
 *	Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT				*
 *	ML 8/6/2007 RETURNING_COUNTS_OF_NEGATIVE_MISSING_ERROR_VALUES_WHEN_EXTRACTING_DATA
 *	CPY 9/3/07 HONG_FOUND_INCONSISTENCY_WITH_OSPCMAINHEADER						*
 *	CPY 10/22/07 QA70-0574 GET_PLOT_COLOR_FOR_GROUP_PLOT						*
 *	ML 10/29/2007 QA70-10599 EXTRACTING_AXIS_LIMITS_FROM_DATARANGE				*
 *	Hong 11/30/07 QA80-10541 FIX_SEMICOLON_SEPARATOR_FAIL_WORK_AS_MIXED_UP_USER_SEPARATOR
 *	Hong 12/05/07 v8.0761 IMPASC_ALLOW_IMPORT_ALL_TEXT_DATA						*
 *	RVD 12/17/2007 QA70-8941 v8.0771 AUTOSIZE_OPTIONS							*
 *	CPY 12/24/07 QA70-10867 IMPORT_EXCEL_INTO_EXISTING_SHEET					*
 *	Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME		*
 *  CPY 3/7/08 WAUTOSIZE_ALLOW_SEL_ROW_COL_SKIP_ROW_HEADER_OPTION				*
 *	ML 3/12/2008 GETTING_CONTOURS_DATA											*
 *	RVD 5/15/2008 qa70-11549 v8.0864 RESIZE_SKIP_ZERO_OPTION					*
 *  Jack 05/26/2008 ADD_LEFT_RIGHT_X_POS_OF_FWHM								*
 *	EJP 2008-06-19 v8.0888 NEW_CHKFORUPDATES_NEED_HANDLE_PATCH					*
 *	Sim 09-18-2008 QA80-12203 MOVE_BIN_IMPORT_TO_VC								*
 *	EJP 2008-10-28 v8.0963 QA80-12393 CHK_FOR_UPDATES_NEED_MORE_INFO			*
 *	DSC 2008-12-02 v8.0982 QA70-12393 CHECK_FOR_UPDATES_NEED_COMPUTER_ID		*
 *	ML 12/24/2008 QA70-12660 P6 DELETING_WHOLE_SHEETS_OPERATION_INTERPLAY		*
 *	DSC 2009-01-12 v8.0996 QA70-12393 ADD_MORE_LIC_DATA_TO_CHECK_FOR_UPDATES	*
 *	YuI 04/20/09 QA70-13138 STOCK_CHARTS										*
 *	Folger 08/19/09 QA80-14148 SUPPORT_SKIP_SPECIFIC_LABELS_WHEN_AUTOSIZE_WKS	*
 *	DSC 10/19/09 QA70-12989 INCREASE_BUFFER_SIZE_FOR_LONGER_LIC_FILES_IN_81		*
 *	TD ML 11-12-2009 QA80-14653 OC_ACCESS_MENU_FROM_CCMDUI						*
 *	Sim 12-29-2009 QA81-14148 REDO_AUTOSIZE_BETTER_HEIGHT_FOR_LABEL				*
 *	Hong 01/20/10 QA80-14785 IMPROVE_IMPORT_SPEED_FOR_TDM_STRING_COL			*
 *	ML 2/5/2010 QA70-15083 SETTING_STRINGS_FROM_ADO_SPEC_CODEPAGE				*
 *	Derek 6/4/2010 OPENCV_BASED_IMAGE_CODE										*
 *	Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
 *------------------------------------------------------------------------------*/
#ifndef _OC_TYPES_H
#define _OC_TYPES_H

/// EJP 12-15-2004 v8.0174 QA70-7252 ADD_ID_TO_ASCIMP
#ifndef _MSC_VER	// Not in VC, so must be Origin C
#include "..\Originlab\DataIDs.h" /// AW 04/30/04
	//#define _id(_ID)	 _id(_ID)	//CPY 4/29/04
#else // _MSC_VER
	#define _id(_ID)	 // //CPY 4/29/04
	#define uint UINT
#endif // _MSC_VER
/// end ADD_ID_TO_ASCIMP

#ifndef _OC_CONST_H
#include "oc_const.h"
#endif
/** >Statistics>Descriptive Statistics
*/
typedef struct tagBasicStats
{
	double	min;
	double	max;
	double	mean;
	double	sd;
	double	total; // the cumulative sum of all the values
	double	ssdm; // sum of squares of diff from mean
	int		N;	  // number of good values in the dataset
	int		Missing; // number of missing values in the dataset
	int		iMax;	 // index (0 offset) of the max value
	int		iMin;	 // index of the min value
} BasicStats;

/// JCG 06/06/03 QA70-4540 v7.0598 CENTROID_FOR_INTEGRATE
#if _OC_VER > 0x0703
	#define _INTEG_ADD_CENTROID
#endif

#ifdef _INTEG_ADD_CENTROID
/** >Mathematics>Integration
*/
typedef struct tagIntegrationResult
{
	int		i1; //the beginning index of the range of integration
	int		i2; //the ending index of the range of integration
	double	x1; //the beginning of x range of integration
	double	x2; //the end of x range of integration
	double	xPeak; //x of peak position relative to baseline
	double	yPeak; //y of peak position relative to basleine
	double	dxPeak; //peak width at half height
	double	dyPeak; //peak's half height from base
	double	Area; //the area of the peak
	double	yPeakBase; // is zero if integrate without base line, otherwise the base line y at peak position
	int		idx1; //the begging index for halfwidth calculation that give rise to dxPeak
	int		idx2; //the ending index for halfwidth caculation that give rise to dxPeak

//	Jack 05/26/2008 ADD_LEFT_RIGHT_X_POS_OF_FWHM
	double	xLeft; //the left x position of fwhm, to replase idx1 which are dependant on the data points
	double	xRight; //the right x position of fwhm, to replase idx2 which are dependant on the data points
//  End ADD_LEFT_RIGHT_X_POS_OF_FWHM
	int		iPeak;		// the index of the peak position

	/// Fisher 2008-10-8 BUG_IN_SURFACE_FITTING_INIT_CODES
	int		nPeakDir;   // the direction of the peak, 1 means positive and -1 means negative 
	/// End BUG_IN_SURFACE_FITTING_INIT_CODES

	double  xCentroid; 		// the x position of centroid
	double  yCentroid; 		// the y position of centroid	

} IntegrationResult;

/**$ >Analysis>Mathematics>Integration
*/
///Arvin 2006-8-04 ADD_STRUCT_OCMATH_INTEGRESULT
//used in ocmath
typedef struct
{
	int		i1, i2;	 // index range of integration
	double	x1, x2;	 // corresponding x range of integration
	double	xPeak, yPeak; // x y of peak position  relative to baseline
	double	dxPeak, dyPeak; // peak width at half height and  the half height from base
	double	Area;
	//double	yPeakBase; // is zero if integrate without base line, otherwise the base line y at peak position
	int		idx1, idx2; // the index for halfwidth calculation that give rise to dxPeak
	int		iPeak;		// the index of the peak position

	double  xCentroid; 		
	double  yCentroid; 		

} ocmath_IntegResult;
//end		
#else 

/**$ >Analysis>Mathematics
*/
typedef struct tagIntegrationResult
{
	int		i1, i2;	 // index range of integration
	double	x1, x2;	 // corresponding x range of integration
	double	xPeak, yPeak; // x y of peak position  
	double	dxPeak, dyPeak; // peak width at half height and peak height from base
	double	Area;
	double	yPeakBase; // is zero if integrate from base line, otherwise the base line y at peak position
	int		idx1, idx2; // the index for halfwidth calculation that give rise to dxPeak
	int		iPeak;		// the index of the peak position
} IntegrationResult;

///Arvin 2006-8-04 ADD_STRUCT_OCMATH_INTEGRESULT
//used in ocmath
/**$ >Analysis>Mathematics
*/
typedef struct
{
	int		i1, i2;	 // index range of integration
	double	x1, x2;	 // corresponding x range of integration
	double	xPeak, yPeak; // x y of peak position
	double	dxPeak, dyPeak; // peak width at half height and peak height from base
	double	Area;
	//double	yPeakBase; // is zero if integrate from base line, otherwise the base line y at peak position
	int		idx1, idx2; // the index for halfwidth calculation that give rise to dxPeak
	int		iPeak;		// the index of the peak position
} ocmath_IntegResult;
///end 
#endif //#if _OC_VER > 0x0703
/// end CENTROID_FOR_INTEGRATE

//------- LY 6/25/01 DAQ data file description header struct
// basic structures from MS Win32
#ifndef _WINBASE_	// structures may be used both in OriginC and in Win32 environment
/** >Date Time
*/
typedef struct _SYSTEMTIME {
    WORD wYear;
    WORD wMonth;
    WORD wDayOfWeek;
    WORD wDay;
    WORD wHour;
    WORD wMinute;
    WORD wSecond;
    WORD wMilliseconds;
} SYSTEMTIME;
#endif //_WINBASE_

#define MAX_ODAQ_COMMENT_LEN	256

typedef struct tagDAQDataHeader {
	double		dCalibrationFactor;	// calibrate factor from the device
	double		dDAQRate;			// DAQ rate, in Hz
	USHORT		usNumOfChannels;	// Number of channels
	USHORT		usDataBlockSize;	// data block size of each channel
	USHORT		usAveragePoints;	// Averaging points during daq, = 0 or 1 if no averaging
	USHORT		usDummy1;			//fill in the empty space
	DWORD		usDeviceID;			// DAQ device identification information
	DWORD		dwDummy2;			//fill in the empty space
	SYSTEMTIME	StartTime;			// Time of 1st data point
	char		szOperator[MAX_ODAQ_COMMENT_LEN];	// text string, application specific
	char		szDescription[MAX_ODAQ_COMMENT_LEN];// text string, application specific
	char		szComments[MAX_ODAQ_COMMENT_LEN]; 	// text string, application specific
} ODAQDataHeader;
//------- 6/25/01

/// Hong 08/08/08 v8.0918b FIX_SEL_OTHER_FAIL_ENABLE_OTHER_DELIMITER
// any change below of ASCIMP_DELIM_* need to check wether update code in construct_ascii_import_options at the same time
#define ASCIMP_DELIM_UNKNOWN		0
#define ASCIMP_DELIM_COMMA			1
#define ASCIMP_DELIM_TAB			2
#define ASCIMP_DELIM_SPACE			3
/// Hong 11/30/07 QA80-10541 FIX_SEMICOLON_SEPARATOR_FAIL_WORK_AS_MIXED_UP_USER_SEPARATOR
//#define ASCIMP_DELIM_OTHER			4
#define ASCIMP_DELIM_DEMICOLON		4
#define ASCIMP_DELIM_OTHER			5
/// end FIX_SEMICOLON_SEPARATOR_FAIL_WORK_AS_MIXED_UP_USER_SEPARATOR

#define ASCIMP_MODE_REPLACE_DATA		0
#define ASCIMP_MODE_APPEND_COLS			1
#define ASCIMP_MODE_APPEND_ROWS			2
/// EJP 01-07-2005 v8.0183 QA70-6555 NEW_IMPORT_MODES
///#define ASCIMP_MODE_DUPLICATE			3
///#define IS_IMPORT_MODE(i) (ASCIMP_MODE_REPLACE_DATA <= (i) && (i) <= ASCIMP_MODE_DUPLICATE)
#define ASCIMP_MODE_NEW_BOOKS			3
#define ASCIMP_MODE_NEW_SHEETS			4
///Sophy 6/4/2010 ORG-220 IMPORT_MULTI_IMAGES_WITH_SAME_DIMS_INTO_SAME_MATRIXSHEET
//#define ASCIMP_MODE_AUTO				5
#define	ASCIMP_MODE_NEW_OBJECTS			5
#define ASCIMP_MODE_AUTO				6
///end IMPORT_MULTI_IMAGES_WITH_SAME_DIMS_INTO_SAME_MATRIXSHEET
#define IS_IMPORT_MODE(i) (ASCIMP_MODE_REPLACE_DATA <= (i) && (i) <= ASCIMP_MODE_AUTO)
/// end NEW_IMPORT_MODES

#define ASCIMP_DELIMITED_DELIM		1
#define	ASCIMP_DELIMITED_FIXED		0

#define ASCIMP_PARTIAL_YES			1
#define ASCIMP_PARTIAL_NO			0


// const for AscImpListCtrlMsg 
enum {
	AIC_LISTCTRL_SETNUMCOLS = 1,
	AIC_LISTCTRL_SETCELL,
	AIC_LISTCTRL_DELROW,
	AIC_LISTCTRL_INSROW,
	AIC_LISTCTRL_SET_GET_COL_TYPE
};

//#define MAX_COLUMN_WIDTH	256
#define MAX_FIXED_COL_WIDTH 256

///---Sim 08-28-2006 DISP_STRUCT_STRING_LEN
/*
#define MAX_SIZE_COL_DESIGN		200
#define MAX_SIZE_COL_FORMATS	200
#define MAX_SIZE_PLOT_TEMPL		80
#define MAX_SIZE_PAGE_TEMPL		80
#define MAX_SIZE_FILE_SPEC		80
#define MAX_SIZE_DESCRIPTION	100
*/
///---END DISP_STRUCT_STRING_LEN

#define ASCIMP_MAX_DELIMITERS 5 /// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM

//int AscImpReadFileStruct(LPCSTR lpcszFilename, ASCIMP* pASCIMPstruct, DWORD dwCntrl=0);
// dwCntrl 
#define AIRF_USE_ASCIMP 0x0001 // if not specified, pASCIMPstruct will be only as output

/// EJP 07-08-2004 v8.0904 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ
#define AI_FLAG_FNAME_TO_WKBK_NAME			0x00000001 // rename workbook to file name
#define AI_FLAG_FNAME_TO_WKBK_COMMENTS		0x00000002 // append file name to workbook comments
#define AI_FLAG_FNAME_TO_COL_COMMENTS		0x00000004 // append file name to column comments
#define AI_FLAG_REMOVE_FNAME_PATH			0x00000008 // remove path when appending file name
/// end SUPPORT_WKBK_IN_IMPWIZ

/// EJP 2005-02-28 v8.0198 QA70-7433 IMPORT_CSV_FILES
#define AI_FLAG_REMOVE_QUOTES				0x00000010 // remove the quotes that protect data with commas and quotes
/// end IMPORT_CSV_FILES
#define AI_FLAG_COMBINE_CONSEC_DELIMS		0x00000020 /// EJP 2005-09-23 v8.0312 QA70-7473 ASC_IMP_MULT_DELIM

///---Sim 02-25-2007 ADD_FILE_PATH_OPTION_FOR_RENAME_WORKBOOK
#define AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME		0x00000040
///---END ADD_FILE_PATH_OPTION_FOR_RENAME_WORKBOOK

/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
#define AI_FLAG_VARIABLE_TO_WKS_NAME		0x00000080
/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE
///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
#define AI_FLAG_VARIABLE_TO_WKBK_NAME		0x00000100
///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF

/// Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
#define AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT		0x00000200
/// end MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT

///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
#define AI_FLAG_FNAME_TO_WKBK_LONG_NAME_ONLY		0x00000400
///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME

/// EJP 09-20-2004 v8.0129 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
#define AI_FLAG_DO_NOT_CALL_OC				0x00010000 // do not call oc import file info function
/// end IMPORT_INFO_STORAGE_CLEANUP

#define AI_FLAG_START_FROM_BOTTOM			0x00020000 /// AW 10/21/06 NEW_IMPASC_OPTIONS 

//------- CPY 3/23/07 QA70-8500 IMPORT_KEEP_COLS_SAME_LENGTH_SHOULD_BE_AN_OPTION
#define AI_FLAG_ADD_NANUM_MAKE_SAME_LENGTH	0x00040000	 // make all columns the same length, otherwise the columns might be diff length
//------

/// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
#define AI_FLAG_NO_IMPORT_INFO_TO_PAGE		0x00080000	// do not write import info into page binary storage
/// end ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED

///---Sim 08-28-2006 ADD_ID_TO_DISP_IMP, add _id to struct members
/*
typedef struct tagDISPIMP {
	double _id(IDE_DISP_IMP_ORIGINVER)		OriginVer;
	int _id(IDE_DISP_IMP_TYPE)				Type;
	int _id(IDE_DISP_IMP_RANGETOGRAPH)		ApplyRangeToGraph;
	int _id(IDE_DISP_IMP_LINKWKS)			LinkWks;
	char _id(IDE_DISP_IMP_COLDESIGN)		ColDesignations[MAX_SIZE_COL_DESIGN];
	int _id(IDE_DISP_IMP_COLDESIGNREP)		ColDesignationsRepetitive;
	char _id(IDE_DISP_IMP_COLFORMATS)		ColFormats[MAX_SIZE_COL_FORMATS];
	int _id(IDE_DISP_IMP_PLOTTYPE)			PlotType;
	char _id(IDE_DISP_IMP_PLOTTEMPLATE)		PlotTemplate[MAX_SIZE_PLOT_TEMPL];
	int _id(IDE_DISP_IMP_PAGETYPE)			TargetWindowType;
	char _id(IDE_DISP_IMP_PAGETEMPLATE)		TargetWindowTemplate[MAX_SIZE_PAGE_TEMPL];
	int _id(IDE_DISP_IMP_FNAMETOWKSLAB)		FilenameToWksLabel;
	char _id(IDE_DISP_IMP_FILESPEC)			FileSpec[MAX_SIZE_FILE_SPEC];
	char _id(IDE_DISP_IMP_DESCRIPTION)		Description[MAX_SIZE_DESCRIPTION];
} DISPIMP;
*/
///---ADD_ID_TO_COMMON_IMP

/// EJP 12-15-2004 v8.0174 QA70-7252 ADD_ID_TO_ASCIMP, add _id to struct members
/** >Import Export
*/
typedef struct tagASCIMP{
	int _id(IDE_ASCIMP_DELIMITED) iDelimited; // 1 if delimited, 0 if Fixed format, szFixedWidth must be filled if iDelimited==0
	int _id(IDE_ASCIMP_DELIMCODE) iDelimiter; // used only if iDelimited==1, one of the ASCIMP_DELIM_TAB, ASCIMP_DELIM_COMMA etc
	char _id(IDE_ASCIMP_DELIMCHAR) cChar;	// used only if iDelimited==1 && iDelimiter==ASCIMP_DELIM_OTHER, char to be used as delimiter
	char _id(IDE_ASCIMP_COLWIDTHS) szFixedWidth[MAX_FIXED_COL_WIDTH];// for iDelimited==0, comma separated string for each col width
	int _id(IDE_ASCIMP_HEADLINES) iHeaderLines; //file header, before those header that can be used as column headings
	int _id(IDE_ASCIMP_SUBHEADLINES) iSubHeaderLines;//subheader block, after iHeaderLines, the number of lines to be used in column labels and names
	int _id(IDE_ASCIMP_AUTOSUBHEAD) iAutoSubHeaderLines; //=1 ignore iSubHeaderLines, auto determine, =0 to use iSubHeaderLines
	int _id(IDE_ASCIMP_AUTOCOLTYPES) iAutoColTypes;//to change column type according to detection, 0=diable, 1=use detection, 2=detect but not to change if text column
	int _id(IDE_ASCIMP_TESTLINES) iTestLines;	// Number of lines used for structure testing that must be consistent
	int _id(IDE_ASCIMP_IMPORTMODE) iMode;//ASCIMP_MODE_REPLACE_DATA, ASCIMP_MODE_APPEND_COLS etc
	int _id(IDE_ASCIMP_NUMCOLUMNS) iNumColumns;//num cols found from auto detection
	int _id(IDE_ASCIMP_PARTIAL) iPartial; // =1 to specify partial import, =0 if whole file imported, ignore iPartialC1, iPartialC2, iPartialR1, R2
	int	_id(IDE_ASCIMP_PARTIALC1) iPartialC1;
	int _id(IDE_ASCIMP_PARTIALC2) iPartialC2;
	int _id(IDE_ASCIMP_PARTIALR1) iPartialR1;
	int _id(IDE_ASCIMP_PARTIALR2) iPartialR2;
	int _id(IDE_ASCIMP_RENAMEWKS) iRenameWks; //=1 to rename worksheet, =0 to keep current name
	int _id(IDE_ASCIMP_APPLYRANGE) iApplyRange;// not used anymore,
	int _id(IDE_ASCIMP_RENAMECOLS) iRenameCols;//=0 to keep column names, =1 to rename columns using 1st line above detected data, =2 use 2nd line etc
	int _id(IDE_ASCIMP_LABEL) iLabels;//=0 to keep current column labels, =1,2 etc as 1st, 2nd line from top of sub header block to rename labels
	int _id(IDE_ASCIMP_MAXLABELS) iMaxLabels;//number of lines in subheader block to be used in column label rename
	int _id(IDE_ASCIMP_LEADZERO) iLeadingZeroes;//=1 to consider 0123 as numbers, =0 if 0123 is considered as text
	/// Hong 12/05/07 v8.0761 IMPASC_ALLOW_IMPORT_ALL_TEXT_DATA
	int _id(IDE_ASCIMP_ALLOWALLTEXT) iAllowAllText;//=1 to allow import all text data, =0 NOT allow
	/// end IMPASC_ALLOW_IMPORT_ALL_TEXT_DATA
	int _id(IDE_ASCIMP_NONNUMERIC) iNonnumeric; // this has to do with what to do when none-numeric is found in numeric column 
	int	_id(IDE_ASCIMP_MAXTESTLINES) iMaxTestLines;	// related to iTestLines, scan upto this number of lines for consistent structure
	int	_id(IDE_ASCIMP_SKIPROWS) iSkipRows; //allow skip rows, =0 if no skipping of rows
	int _id(IDE_ASCIMP_READROWS) iReadRows; // used only if iSkipRows > 0, and must not be 0. import will read iReadRows, then skip iSkipRows, then read iReadRows again
	char _id(IDE_ASCIMP_DATEFORMAT) szDateFormat[MAX_SIZE_CUSTOM_FORMAT];
	int _id(IDE_ASCIMP_SKIPCHARS) iLabelSkipChars;
	/// EJP 06-22-2004 v8.0894 QA70-6523 MORE_HEADER_LINE_TYPES
	int _id(IDE_ASCIMP_LONGNAMES) nLongNames; // Header line containing long column names
	int _id(IDE_ASCIMP_UNITS) nUnits; // Header line containing column units
	int _id(IDE_ASCIMP_FIRSTPARAMS) nFirstParams; // First header line containing column parameters
	int _id(IDE_ASCIMP_NUMPARAMS) nNumParams; // Number of header lines containing column parameters
	///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	int _id(IDE_ASCIMP_FIRSTUSERPARAMS) nFirstUserParams; // First header line containing column user parameters
	int _id(IDE_ASCIMP_NUMUSERPARAMS) nNumUserParams; // Number of header lines containing column user parameters
	///---END SUPPORT_USER_PARAMETER
	int _id(IDE_ASCIMP_FIRSTSAVE) nFirstSave; // First header line to save into binary storage
	int _id(IDE_ASCIMP_NUMSAVE) nNumSave; // Number of header lines to save into binary storage
	/// EJP 07-08-2004 v8.0904 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ
	DWORD _id(IDE_ASCIMP_FLAGS) flags; // see AI_FLAG_* for uses
	/// end SUPPORT_WKBK_IN_IMPWIZ
	/// end MORE_HEADER_LINE_TYPES
	int _id(IDE_ASCIMP_NUMSEP) nNumSep; //decimal char,'.'=NF_IS_AMERICAN, ','=NF_IS_EUROPEAN
	///Cheney 2007-2-6 ADD_OPTION_TO_SUPPORT_SPECIAL_NUM_FORMAT_FOR_ASCIMP	
	int _id(IDE_ASCIMP_SPECIALFORMAT) nSpeFmt; 
	///end ADD_OPTION_TO_SUPPORT_SPECIAL_NUM_FORMAT_FOR_ASCIMP
	/// EJP 2005-09-28 v8.0313 QA70-7473 ASC_IMP_MULT_DELIM
	char _id(IDE_ASCIMP_DELIMITERS) cDelimiters[ASCIMP_MAX_DELIMITERS];
	///Cheney 2007-2-6 ADD_OPTION_TO_SUPPORT_SPECIAL_NUM_FORMAT_FOR_ASCIMP	
	char _id(IDE_ASCIMP_DELIMITERSARRAY) cDelimitersArray[ASCIMP_MAX_DELIMITERS]; //support Delimiters like "AI", "BIG"
	///end ADD_OPTION_TO_SUPPORT_SPECIAL_NUM_FORMAT_FOR_ASCIMP
	char _id(IDE_ASCIMP_QUOTECHAR) cQuote;
	/// end ASC_IMP_MULT_DELIM
	char _id(IDE_ASCIMP_VERSION)	cVersion;
} ASCIMP;

///---Sim 09-18-2008 QA80-12203 MOVE_BIN_IMPORT_TO_VC
typedef struct tagCBINIMP {
	int		iHeaderBytes;				//number of bytes for header
	int		iAutoColTypes;				//indicate if set col type explicitly
	int		iNumColumns;				//number of columns
	int		iPartial;					//indicate partial data will be read from the file
	int		iPartialC1;					//partial reading start column number, 0 based, include this column
	int		iPartialC2;					//partial reading end column number, this column will not be included
	int		iPartialR1;					//partial reading start row number, 0 based, this row will be included
	int		iPartialR2;					//partial reading end row number, this row will not be included
	int		iRenameWks;					//if rename worksheet name to the file name
	int		iBigEndian;					//numeric value byte order, use big endian if TRUE
	int		iApplyRange;				//
	int		iMode;						// Data destination in worksheet. See ASCIMP_MODE_* constants in OC_Types.h
	int		iSkipRows;					// number of data rows to skip for each row of data read
	int		iReadRows;
	BYTE*	pParamType;		//data type for each column
	WORD*	pParamSize;		//size of the data type for each column, bytes
	WORD*	pParamCount;		//number of consective columns with same data type
	int		nNumParams;
	DWORD	flags; /// EJP 07-21-2004 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ
} CBINIMP;
///---END QA80-12203 MOVE_BIN_IMPORT_TO_VC

/* Hong, rollback change
/// Hong 07/08/08 QA80-11811 v8.0897 IMPROVE_CSV_IMPORT_SPEED_BY_MOVE_OC_TO_VC
typedef struct	tagCSVIMP
{
	int _id(IDE_CSVIMP_HEADLINES)		iHeaderLines; //file header, before those header that can be used as column headings
	int _id(IDE_CSVIMP_SUBHEADLINES)	iSubHeaderLines; //subheader block, after iHeaderLines, the number of lines to be used in column labels and names
	int _id(IDE_CSVIMP_RENAMECOLS)		iRenameCols; //=0 to keep column names, =1 to rename columns using 1st line above detected data, =2 use 2nd line etc
	int _id(IDE_CSVIMP_LONGNAMES)		nLongNames; // Header line containing long column names
	int _id(IDE_CSVIMP_UNITS)			nUnits; // Header line containing column units
	int _id(IDE_CSVIMP_COMMENT)			iComments; //=0 to keep current column labels, =1,2 etc as 1st, 2nd line from top of sub header block to rename labels
	int _id(IDE_CSVIMP_NUMCOMMENT)		iNumComments; //number of lines in subheader block to be used in column label rename
	int _id(IDE_CSVIMP_FIRSTPARAMS)		nFirstParams; // First header line containing column parameters
	int _id(IDE_CSVIMP_NUMPARAMS)		nNumParams; // Number of header lines containing column parameters	
	int _id(IDE_CSVIMP_FIRSTUSERPARAMS)	nFirstUserParams; // First header line containing column user parameters
	int _id(IDE_CSVIMP_NUMUSERPARAMS)	nNumUserParams;	// Number of header lines containing column user parameters
	int _id(IDE_CSVIMP_PARTIAL)			iPartial; // =1 to specify partial import, =0 if whole file imported, ignore iPartialC1, iPartialC2, iPartialR1, R2
	int	_id(IDE_CSVIMP_PARTIALC1)		iPartialC1;
	int _id(IDE_CSVIMP_PARTIALC2)		iPartialC2;
	int _id(IDE_CSVIMP_PARTIALR1)		iPartialR1;
	int _id(IDE_CSVIMP_PARTIALR2)		iPartialR2;
} CSVIMP;
/// end IMPROVE_CSV_IMPORT_SPEED_BY_MOVE_OC_TO_VC
*/

///Hong 08-28-2006 ADD_ID_TO_BIN_IMP, add _id to struct members
/*
#ifndef	_MSC_VER
typedef struct tagBINIMP {
	int _id(IDE_BINIMP_HEADERBYTES)		iHeaderBytes;				//number of bytes for header
	int _id(IDE_BINIMP_AUTOCOLTYPES)	iAutoColTypes;				//indicate if set col type explicitly
	int _id(IDE_BINIMP_NUMCOLUMNS)		iNumColumns;				//number of columns
	int _id(IDE_BINIMP_PARTIAL)			iPartial;					//indicate partial data will be read from the file
	int _id(IDE_BINIMP_PARTIALC1)		iPartialC1;					//partial reading start column number, 0 based, include this column
	int _id(IDE_BINIMP_PARTIALC2)		iPartialC2;					//partial reading end column number, this column will not be included
	int _id(IDE_BINIMP_PARTIALR1)		iPartialR1;					//partial reading start row number, 0 based, this row will be included
	int _id(IDE_BINIMP_PARTIALR2)		iPartialR2;					//partial reading end row number, this row will not be included
	int _id(IDE_BINIMP_RENAMEWKS)		iRenameWks;					//if rename worksheet name to the file name
	int _id(IDE_BINIMP_BIGENDIAN)		iBigEndian;					//numeric value byte order, use big endian if TRUE
	int _id(IDE_BINIMP_APPLYRANGE)		iApplyRange;				//
	int _id(IDE_BINIMP_MODE)			iMode;						// Data destination in worksheet. See ASCIMP_MODE_* constants in OC_Types.h
	int _id(IDE_BINIMP_SKIPROWS)		iSkipRows;					// number of data rows to skip for each row of data read
	int _id(IDE_BINIMP_READROWS)		iReadRows;
	vector<BYTE> _id(IDE_BINIMP_PARAMTYPE)	vParamType;		//data type for each column
	vector<WORD> _id(IDE_BINIMP_PARAMSIZE)	vParamSize;		//size of the data type for each column, bytes
	vector<WORD> _id(IDE_BINIMP_PARAMCOUNT)	vParamCount;		//number of consective columns with same data type
	DWORD _id(IDE_BINIMP_FLAGS)			flags; /// EJP 07-21-2004 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ
} BINIMP;
#endif//	_MSC_VER
*/
///END ADD_ID_TO_BIN_IMP, add _id to struct members

/// EJP 09-01-2004 v8.0127 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
/** >Import Export
*/
typedef struct tagASCIMPRESULT {
	int nR1; // first row to receive data
	int	nC1; // first column to receive data
	int nR2; // last row to receive data
	int nC2; // last column to receive data
	DWORD uid; // UID of the DataRange created as result of import
} ASCIMPRESULT;
/// end IMPORT_INFO_STORAGE_CLEANUP

//CPY 5/6/03, rename to be iRenameWKS to iRenameWks to be more consistent with other codes, case did not matter in Origin 7 for struct members
//CPY 8/27/03 QA70-5073 ADD_READ_ROWS_TO_ASCII_IMP_STRUCT, added iReadRows and also swap iMaxTestLines with iSkipRows so iSkipRows and iReadRows are next to each other

//typedef struct tagNLSFCntrl {
//	
//	char 	szYdataName[NAME_SIZE]; 		// nlsf.fitData$
//	char 	szFuncName[NLSF_FUNCTION_NAME_SIZE]; // nlsf.func$
//	char 	szWtDataName[NAME_SIZE]; 		// nlsf.w$
	//char	szFuncXDataName[MAX_NAME_SIZE];	// nlsf.funcX$
	//char	szFuncYDataName[MAX_NAME_SIZE];	// nlsf.funcCol$
//	double 	ChisqDoF; 						// nlsf.chiSqr
//	double 	SSR; 							// nlsf.ssr
//	double 	Correlation; 					// nlsf.cor
//	double 	COD; 							// nlsf.cod
//	double 	MuFinal; 						// nlsf.muMin
//	double 	Mu; 							// nlsf.mu
//	double 	DerivStep; 						// nlsf.derivStep
//	double 	Tolerance; 						// nlsf.tolerance
//	double 	Confidence; 					// nlsf.conf
//	double 	Prediction; 					// nlsf.pred
//	int		inPara;							// nlsf.nPara	
//	int    	inParaVary; 					// nlsf.nParaVary
//	int    	imaxIter; 						// nlsf.maxIter
//	int    	idataBegin; 					// nlsf.dataBegin
//	int    	idataEnd; 						// nlsf.dataEnd
//	int    	idataStep; 						// nlsf.dataStep
//	int    	inPoints; 						// nlsf.nPoints		
//	//int		ixBegin;						// nlsf.xBegin
	//int		ixEnd;							// nlsf.xEnd;
	//int		ixPoints						// nlsf.xPoints;
//	int    	iDOF; 							// nlsf.dof
//	int    	inConstr; 						// nlsf.nConstr
//	int    	inConstrEff; 					// nlsf.nConstrEff
//	int		iwType; 						// nlsf.wType 0=none, 1=inst, 2=stat, 3=arb, 4=direct
//	double 	Par[NLSF_MAX_PARAM]; 			// nlsf.Pn or nlsf.Vn
//	double 	Err[NLSF_MAX_PARAM]; 			// nlsf.En
//	double 	ConfIntv[NLSF_MAX_PARAM]; 		// nlsf.Cn
//	double 	Dep[NLSF_MAX_PARAM]; 			// nlsf.Dn
//	BOOL	openGraph;						// doesn't need an associated nlsf object property/method
//	BOOL 	createCurve; 					// use nlsf.end(13) for false and nlsf.end(12) for true
//	BOOL 	confBands; 						// use nlsf.createCurves(C) when true
//	BOOL 	predBands; 						// use nlsf.createCurves(P) when true
//	BOOL 	createWks; 						// use nlsf.paramWKS(wksName); when true
//	BOOL 	pasteToPlot; 					// use nlsf.pasteParams(plot); when true
//	BOOL 	pasteToResults; 				// use nlsf.pasteParams(results); when true
//	//BOOL 	sameXasData;					// nlsf.xmode=0 for true(sameX) or nlsf.xmode=4 for false(uniformX)
	
//} NLSFCntrl;  // NLSFControl is reserved already for internal use

/// Hong 07/01/08 QA80-11784 BRING_BACK_SPC_COLUMN_CORNER_INFO
#define		SPC_RESOLUTION_LENGTH		9
#define		SPC_SOURCE_LENGTH			9
#define		SPC_SPARE_SIZE				8
#define		SPC_COMMENT_LENGTH			130
#define		SPC_AXIS_LABEL_LENGTH		30
#define		SPC_METHOD_SIZE				48
/// end BRING_BACK_SPC_COLUMN_CORNER_INFO

/// SY 2006-11-14 v8.0510 SPC_IN_DATASHEET_WITH_TREE
//----- CPY 9/3/07 HONG_FOUND_INCONSISTENCY_WITH_OSPCMAINHEADER
//#if _OC_VER > 0x0703
#ifdef _NEW_SPC_HEADER_FORMAT
//-----
/** >Import Export
*/
typedef struct OSPCMAINHEADER {         // 'new' SPC file header format */
	BYTE   ftflgs;      /* Flag bits defined below */
	BYTE   fversn;      /* 0x4B=> new LSB 1st, 0x4C=> new MSB 1st, 0x4D=> old format */
	BYTE   fexper;      /* Instrument technique code (see below) */
	char   fexp;        /* Fraction scaling exponent integer (80h=>float) */
	DWORD  fnpts;       /* Integer number of points (or TXYXYS directory position) */
	double ffirst;      /* Floating X coordinate of first point */
	double flast;       /* Floating X coordinate of last point */
	DWORD  fnsub;       /* Integer number of subfiles (1 if not TMULTI) */
	BYTE   fxtype;      /* Type of X axis units (see definitions below) */
	BYTE   fytype;      /* Type of Y axis units (see definitions below) */
	BYTE   fztype;      /* Type of Z axis units (see definitions below) */
	BYTE   fpost;       /* Posting disposition (see GRAMSDDE.H) */
	DWORD  fdate;       /* Date/Time LSB: min=6b,hour=5b,day=5b,month=4b,year=12b */
	char   fres[SPC_RESOLUTION_LENGTH];     /* Resolution description text (null terminated) */
	char   fsource[SPC_SOURCE_LENGTH];  /* Source instrument description text (null terminated) */
	WORD   fpeakpt;     /* Peak point number for interferograms (0=not known) */
	float  fspare[SPC_SPARE_SIZE];   /* Used for Array Basic storage */
	char   fcmnt[SPC_COMMENT_LENGTH];  /* Null terminated comment ASCII text string */
	char   fcatxt[SPC_AXIS_LABEL_LENGTH];  /* X,Y,Z axis label strings if ftflgs=TALABS */
	DWORD  flogoff;     /* File offset to log block or 0 (see above) */
	DWORD  fmods;       /* File Modification Flags (see below: 1=A,2=B,4=C,8=D..) */
	BYTE   fprocs;      /* Processing code (see GRAMSDDE.H) */
	BYTE   flevel;      /* Calibration level plus one (1 = not calibration data) */
	WORD   fsampin;     /* Sub-method sample injection number (1 = first or only ) */
	float  ffactor;     /* Floating data multiplier concentration factor (IEEE-32) */
	char   fmethod[SPC_METHOD_SIZE	]; /* Method/program/data filename w/extensions comma list */
	float  fzinc;       /* Z subfile increment (0 = use 1st subnext-subfirst) */
	DWORD  fwplanes;    /* Number of planes for 4D with W dimension (0=normal) */
	float  fwinc;       /* W plane increment (only if fwplanes is not 0) */
	BYTE   fwtype;      /* Type of W axis units (see definitions below) */
	char   freserv[187];    /* Reserved (must be set to zero) */
} OSPCMAINHeader;

/** >Import Export
*/
typedef struct OSPCSUBHEADER {         /* subfile record header format */
	BYTE  subflgs;      /* Flags as defined above */
	char  subexp;       /* Exponent for sub-file's Y values (80h=>float) */
	WORD  subindx;      /* Integer index number of trace subfile (0=first) */
	float subtime;      /* Floating time for trace (Z axis corrdinate) */
	float subnext;      /* Floating time for next trace (May be same as beg) */
	float subnois;      /* Floating peak pick noise level if high byte nonzero */
	DWORD subnpts;      /* Integer number of subfile points for TXYXYS type */
	DWORD subscan;      /* Integer number of co-added scans or 0 (for collect) */
	float subwlevel;    /* Floating W axis value (if fwplanes non-zero) */
	char  subresv[4];   /* Reserved area (must be set to zero) */
} OSPCSUBHeader;

#else // !_NEW_SPC_HEADER_FORMAT
/// end SPC_IN_DATASHEET_WITH_TREE

//LY 1/28/02 QA70-460 ORIGIN_C_SPC_INFO_ACCESS
// OSPCMAINHEADER and OSPCSUBHEADER mostly are copy from SPCHDR and SUBHDR in SPC.h
// at here just save the field can be accessed by gspciolib.dll function
typedef struct OSPCMAINHEADER {
	/// SY 04-25-2003 QA70-3985 SAVE_TO_SPC_FILE
	BYTE		ftflgs;		 //	Used to save spcFileType: spcFileTypeEven = 0, spcFileTypeXYY = 1, spcFileTypeXYXY = 2
							 // This is needed for creating SPC file.
	/// end SAVE_TO_SPC_FILE
    BYTE		fexper;      // Instrument technique code 
    DWORD		fnpts;       // Integer number of points 
    double		ffirst;      // Floating X coordinate of first point 
    double		flast;       // Floating X coordinate of last point 
    DWORD		fnsub;       // Integer number of subfiles (1 if not TMULTI) 
    BYTE		fxtype;      // Type of X axis units 
    BYTE		fytype;      // Type of Y axis units
    BYTE		fztype;      // Type of Z axis units 
    SYSTEMTIME  fdate;       // Date/Time 
    char		fres[SPC_RESOLUTION_LENGTH];     // Resolution description text (null terminated)
    char		fsource[SPC_SOURCE_LENGTH];  // Source instrument description text (null terminated) 
    WORD		fpeakpt;     // Peak point number for interferograms (0=not known) 
    float		fspare[SPC_SPARE_SIZE];   // Used for Array Basic storage 
    char		fcmnt[SPC_COMMENT_LENGTH];  // Null terminated comment ASCII text string 
    char		fcatxt[SPC_AXIS_LABEL_LENGTH];  // X axis label strings 
    char		fcatyt[SPC_AXIS_LABEL_LENGTH];  // Y axis label strings 
    char		fcatzt[SPC_AXIS_LABEL_LENGTH];  // Z axis label strings 
    DWORD		fmods;       // File Modification Flags (see below: 1=A,2=B,4=C,8=D..) 
    char		fmethod[SPC_METHOD_SIZE]; // Method/program/data filename w/extensions comma list 
    float		fzinc;       // Z subfile increment (0 = use 1st subnext-subfirst) 
    DWORD		fwplanes;    // Number of planes for 4D with W dimension (0=normal) 
    float		fwinc;       // W plane increment (only if fwplanes is not 0) 
    BYTE		fwtype;      // Type of W axis units (see definitions below) 
}OSPCMAINHeader;

typedef struct OSPCSUBHEADER {
    WORD		subindex;      // Integer index number of trace subfile (0=first)
	char		colname[NAME_SIZE];	// this is never used in Origin80 any more. (this field tell the subfile saved in which column, this is our info, not spc data file.)
	float		fZstart;
	float		fZend;
    DWORD		subnpts;      // Integer number of subfile points for TXYXYS type
    DWORD		subscan;      // Integer number of co-added scans or 0 (for collect)
    float		subwlevel;    // Floating W axis value (if fwplanes non-zero)
}OSPCSUBHeader;  
//end QA70-460 ORIGIN_C_SPC_INFO_ACCESS

#endif // !_NEW_SPC_HEADER_FORMAT /// SY 2006-11-14 v8.0510 SPC_IN_DATASHEET_WITH_TREE

///	DVT 7/9/03 QA70-4801 v7.0621 OC_GET_PAGE_SYSTEM_INFO
/** >Internal Origin Objects>Page and Layer
*/
typedef struct tagPageSystemInfo
{
	double dCreated;
	double dModified;
	int nSize;
	int nDependents;
} PageSystemInfo;
///	end OC_GET_PAGE_SYSTEM_INFO

//----------- CPY 6/15/04 QA70-6294 OC_DATA_PLOT_SEL_INFO_CONSOLIDATION
#define MAX_RANGE_SIZE	(NAME_SIZE*8)
/** >Internal Origin Objects>DataPlot
*/
typedef struct tagDataPlotStrings {
	char    szPlotDesigDescription[MAX_RANGE_SIZE];
	char    szWorkBook[NAME_SIZE];
	char	szSheet[MAX_SHEET_NAME+1];
	char	szIndepRange[MAX_RANGE_SIZE]; // always X
	char	szDepRange[MAX_RANGE_SIZE];// Y but can also be Z
	char	szIndepYRange[MAX_RANGE_SIZE]; // possible if XYZ, then this holds the Y range
	char	szYErrRange[MAX_RANGE_SIZE];
	char	szXErrRange[MAX_RANGE_SIZE];

	char	szLegned[MAXLINE];
	// full dataset names
	char    szX[NAME_SIZE];
	char    szY[NAME_SIZE];
	char    szZ[NAME_SIZE];
	char    szXErr[NAME_SIZE];
	char    szYErr[NAME_SIZE];
	char    szL[NAME_SIZE];
	//-------- CPY 6/18/05 QA70-7820 DATA_PLOT_INFO_AND_LOOSE_DATASET_SUPPORT
	char	szYPlusErr[NAME_SIZE];
	char	szYMinusErr[NAME_SIZE];
	char	szSize[NAME_SIZE];
	char	szColor[NAME_SIZE];
	char	szAngle[NAME_SIZE];
	char	szMagnitude[NAME_SIZE];
	char	szXEnd[NAME_SIZE];
	char	szYEnd[NAME_SIZE];
	char	szZEnd[NAME_SIZE];
	//---------
	/// YuI 04/20/09 QA70-13138 STOCK_CHARTS
	char	szOpen[NAME_SIZE];
	char	szHigh[NAME_SIZE];
	char	szLow[NAME_SIZE];
	char	szClose[NAME_SIZE];
	char	szOpenRange[MAX_RANGE_SIZE];
	char	szHighRange[MAX_RANGE_SIZE];
	char	szLowRange[MAX_RANGE_SIZE];
	char	szCloseRange[MAX_RANGE_SIZE];
	/// end STOCK_CHARTS
	int		i1;
	int		i2;// -1 if auto range
	UINT	iMin;
	UINT	iMax;// wks data range
} DataPlotStrings;
//-----------

//---- CPY 8/23/2007 QA70-10293	CSV_IMPORT_NEED_TO_HANDLE_CELLS_WITH_LF_AND_ALSO_NEED_MAC_IMPORT
/** >File Management
*/
typedef struct tagStdioFileInfo
{
	int nCRLF;
	int nLF;
	int nCR;
	int nCRCR;
	int nMaxLineLength;
} stdioFileInfo;
//---- end CSV_IMPORT_NEED_TO_HANDLE_CELLS_WITH_LF_AND_ALSO_NEED_MAC_IMPORT 


/// YuI 11/02/04 V7.5158 QA70-7122 OC_DATA_PLOT_CREATION
#define		HISTOGRAM_BIN_COUNT_LIMIT		1000
#define		MAX_HIST_POINTS					(HISTOGRAM_BIN_COUNT_LIMIT * 2)	  // two points for every bin
#define		BEGIN_PERCENTILE_POSITIONS		(MAX_HIST_POINTS + 1)
typedef	enum tagPERCENTILEDATASETPOSITIONS
{
	PDSP_HIST_MIN = BEGIN_PERCENTILE_POSITIONS,
	PDSP_HIST_INC,
	PDSP_NUM_HIST,
	PDSP_DATA_SIZE,
	PDSP_WHISK_BOT,
	PDSP_WHISK_TOP,
	PDSP_BAR_TOP_X,
	PDSP_BAR_TOP,
	PDSP_BAR_CENTER,
	PDSP_BAR_BOT,
	PDSP_BAR_BOT_X,
	PDSP_MAX_HIST_COUNT,
	PDSP_DUMMY_POSITION, // for backward-forward compatibility
	PDSP_STRING_ORIGINAL_NAME,
	PDSP_TOTAL_NUM_DATA_POINTS,	// total number of points that are stored beginning with PDSP_PDSP_ACTUAL_DATA
	PDSP_PERC_1,
	PDSP_PERC_5,
	PDSP_PERC_10,
	PDSP_PERC_25,
	PDSP_PERC_50,
	PDSP_PERC_75,
	PDSP_PERC_90,
	PDSP_PERC_95,
	PDSP_PERC_99,
	PDSP_PERC_MAX,	// maximum of data
	PDSP_PERC_MIN,	// minimum of data
	PDSP_PERC_MEAN,	// mean of data
	PDSP_PERC_SD,	// standard dev. of data
	PDSP_PERC_SE,	// standard error of data		
	PDSP_PERC_P5,	//.5
	PDSP_PERC_2P5,
	PDSP_PERC_97P5,
	PDSP_PERC_99P5,
	PDSP_LOW_MEDIAN_CONFIDENCE,
	PDSP_UP_MEDIAN_CONFIDENCE,
}	PERCENTILEDATASETPOSITIONS;
/// end OC_DATA_PLOT_CREATION

/// RVD 8/5/2005 v8.0283 LIMIT_AUTOSIZE_ROWCOL
//#define	DEFAULT_LIMIT		(-1)  //---- CPY 10/17/08 QA70-12392-S1 DBL_CLICK_BETWEEN_COL_SHOULD_AUTO_FIT_COL -1 is used directly in code to mean ignore, so ok to remove this

/// RVD 12/17/2007 QA70-8941 v8.0771 AUTOSIZE_OPTIONS
typedef enum	tagOLIMITSCNTRL
{
	OLC_APPLY_LIMITS_HEADER	= 0x00010000,
	/// RVD 5/15/2008 qa70-11549 v8.0864 RESIZE_SKIP_ZERO_OPTION
	OLC_SKIP_HIDDEN			= 0x00020000,
	OLC_NO_MARGIN			= 0x00040000,
	/// end RESIZE_SKIP_ZERO_OPTION
	OLC_SKIP_HEADER			= 0x00001000, // CPY 3/7/08 WAUTOSIZE_ALLOW_SEL_ROW_COL_SKIP_ROW_HEADER_OPTION
}	OLIMITSCNTRL;
/// end AUTOSIZE_OPTIONS

typedef struct tagOLIMITS
{
	int			nMin;
	int			nMax;
	/// RVD 12/17/2007 QA70-8941 v8.0771 AUTOSIZE_OPTIONS
	int			nCount;			// how many to autosize: <0 for unlimited (slow), 0 for default (40 columns, 60 rows)
	int			nMargin;
	DWORD		dwCntrl;		// OLIMITSCNTRL
	/// end AUTOSIZE_OPTIONS
}	OLIMITS, *POLIMITS;

///------ Folger 08/19/09 QA80-14148 SUPPORT_SKIP_SPECIFIC_LABELS_WHEN_AUTOSIZE_WKS
typedef struct tagOLABELTYPES
{
	int*		pnTypes;
	int			nCount;
}OLABELTYPES, *POLABELTYPES;
///------ End SUPPORT_SKIP_SPECIFIC_LABELS_WHEN_AUTOSIZE_WKS

///---Sim 12-29-2009 QA81-14148 REDO_AUTOSIZE_BETTER_HEIGHT_FOR_LABEL
typedef struct tagOLABELSPEC
{
	OLABELTYPES		labels;
	BOOL			bSkip;
}OLABELSPEC, *POLABELSPEC;
///---END QA81-14148 REDO_AUTOSIZE_BETTER_HEIGHT_FOR_LABEL

typedef struct tagOGRIDLIMITS
{
	OLIMITS		col;
	OLIMITS		row;
	///------ Folger 08/19/09 QA80-14148 SUPPORT_SKIP_SPECIFIC_LABELS_WHEN_AUTOSIZE_WKS
	///---Sim 12-29-2009 QA81-14148 REDO_AUTOSIZE_BETTER_HEIGHT_FOR_LABEL
	//OLABELTYPES	labelsToSkip;
	BOOL		bLabelOnly;
	OLABELSPEC	speclabels;
	///---END QA81-14148 REDO_AUTOSIZE_BETTER_HEIGHT_FOR_LABEL
	///------ End SUPPORT_SKIP_SPECIFIC_LABELS_WHEN_AUTOSIZE_WKS
}	OGRIDLIMITS, *POGRIDLIMITS;
/// end LIMIT_AUTOSIZE_ROWCOL

///Arvin 12/19/06 PRODUCE_STREL_STRUCT_FOR_MORPHOLOGIC_OPERATION
/** >Image Processing>Morphology
*/
typedef struct
{
	UINT nRows;
	UINT nCols;
	double* pNHoodMat;
	double* pHeightMat;
}StrelResult;
///end PRODUCE_STREL_STRUCT_FOR_MORPHOLOGIC_OPERATION

/// RVD 10/27/2005 QA70-8233 v8.0325 LEAD_EPRINT
/////////////////////////////////////////////////////////////////////////////////
// struct LeadPrintSettings
///////////////////////////////////////////////////////////////////////////////// 	
//-- for LeadPrintSettings::dwOptions
typedef enum tagLeadSettingsOptions
{
	OPT_FORMAT_MASK		= 0x000000FF,
	// PDF related
	OPT_SHOWMENU		= 0x00000001,
	OPT_SHOWTOOLBAR		= 0x00000002,
	OPT_SHOWWNDCNTRL	= 0x00000004,

	// common
	OPT_PRINT_MASK		= 0x0000FF00,
	OPT_PRINT_PORTRAIT	= 0x00000100,
}   LeadSettingsOptions;

/** >Import Export
*/
struct LeadPrintSettings
{
	LPCTSTR		lpcszFileName;
	int			nMultiPage;		// LeadPrintMulti
	int			nFormat;		// LeadPrintFormat
	//BOOL		bShowMenu;		// menu in pdf window
	//BOOL		bShowToolbar;		// toolbar in pdf window
	//BOOL		bShowWindowControl;	// scrollbar and other navigation controls
	DWORD		dwOptions;

};

typedef enum tagLeadPrintMulti
{
	LPM_SEPARATEFILES = 0,
	LPM_SEPARATEJOBS,
}	LeadPrintMulti;

typedef enum tagLeadPrintFormat
{
	LPF_PDF = 1300,
}	LeadPrintFormat;
/// end LEAD_EPRINT

/// YuI 11/27/06 QA70-9156 MORE_OPTIONS_TO_CONNECTING_OBJECTS
// moved from  mswin.h

// Comments last updated by Frank on 04/29/2005
/** >User Interface Controls
	The RECT structure defines the coordinates of the upper-left and lower-right corners of a rectangle. 

	Members:
		left = Specifies the x-coordinate of the upper-left corner of the rectangle. 
		top = Specifies the y-coordinate of the upper-left corner of the rectangle. 
		right = Specifies the x-coordinate of the lower-right corner of the rectangle. 
		bottom = Specifies the y-coordinate of the lower-right corner of the rectangle. 
*/
#ifndef _MSC_VER
typedef struct tagRECT
{
    int    left;
    int    top;
    int    right;
    int    bottom;
} RECT;
#define RECT_WIDTH(_RR) (_RR.right - _RR.left)
#define RECT_HEIGHT(_RR) (_RR.bottom - _RR.top)
#define RECT_X(_RR)		((_RR.left + _RR.right)/2)
#define RECT_Y(_RR)		((_RR.bottom + _RR.top)/2)
#endif// _MSC_VER
/// end MORE_OPTIONS_TO_CONNECTING_OBJECTS

/// AW 06/06/05 QA80-7776 SUPPOT_CHECK_FOR_UPDATE_IN_OC
// moved from orgdll.h

///DSC 2009-01-12 v8.0996 QA70-12393 ADD_MORE_LIC_DATA_TO_CHECK_FOR_UPDATES
enum {	UNECRYPTED_USERNAME_SIZE=100,
		ECRYPTED_USERNAME_SIZE=2*MAXLINE, 
		UNECRYPTED_COMPANYNAME_SIZE=100,
		ECRYPTED_COMPANYNAME_SIZE=2*MAXLINE,
		UNECRYPTED_HOSTIDTYPE=10,
		ECRYPTED_HOSTIDTYPE=MAXLINE, 
		///DSC 10/19/09 INCREASE_BUFFER_SIZE_FOR_LONGER_LIC_FILES_IN_81
		//UNECRYPTED_FLEXLICSTRING_SIZE=300, 
		//ECRYPTED_FLEXLICSTRING_SIZE=650,
		UNECRYPTED_FLEXLICSTRING_SIZE=500, 
		ECRYPTED_FLEXLICSTRING_SIZE=1050, // 2*UNECRYPTED_FLEXLICSTRING_SIZE  + enough for key + signature
		///end INCREASE_BUFFER_SIZE_FOR_LONGER_LIC_FILES_IN_81

};
///end ADD_MORE_LIC_DATA_TO_CHECK_FOR_UPDATES
typedef struct {
	DWORD dwOriginType;
	LPSTR lpstrSerialNumber;
	LPSTR lpstrRegistrationID;
	DWORD dwSerialNumber;
	//LY  1/9/02  IMPROVE_GET_USER_INFO
	LPSTR lpstrLanguageCharater;
	LPSTR lpstrServiceReleaseStr;
	float fVersionNumber;
	//end IMPROVE_GET_USER_INFO
	/// SY 06-11-2003 QA70-3774 v7.0601 CHECK_FOR_UPDATES_FOR_CLIENTS
	BOOL bIsClient; 
	/// end CHECK_FOR_UPDATES_FOR_CLIENTS
	LPSTR lpstrLanguageRestype;	   /// AW 06/06/05 QA80-7776 SUPPOT_CHECK_FOR_UPDATE_IN_OC

	/// EJP 2008-10-28 v8.0963 QA80-12393 CHK_FOR_UPDATES_NEED_MORE_INFO
	char szUserName[2*MAXLINE];
	char szCompanyName[2*MAXLINE];
	///DSC 2009-01-12 v8.0996 QA70-12393 ADD_MORE_LIC_DATA_TO_CHECK_FOR_UPDATES
	// char szLic[MAXFULLPATH];	Flex Lic string <300, so need larger buffer for encrypted
	char szLic[ECRYPTED_FLEXLICSTRING_SIZE];
	///end ADD_MORE_LIC_DATA_TO_CHECK_FOR_UPDATES
	/// end CHK_FOR_UPDATES_NEED_MORE_INFO

	///DSC 2008-12-02 v8.0982 QA70-12393 CHECK_FOR_UPDATES_NEED_COMPUTER_ID
	char szComputerID[2*MAXLINE];
	///end CHECK_FOR_UPDATES_NEED_COMPUTER_ID

	///DSC 2009-01-12 v8.0996 QA70-12393 ADD_MORE_LIC_DATA_TO_CHECK_FOR_UPDA
	char szHostIDType[MAXLINE];
	///end ADD_MORE_LIC_DATA_TO_CHECK_FOR_UPDATES

} stWCBUSERINFO;
/// END SUPPOT_CHECK_FOR_UPDATE_IN_OC

/// AW 02/12/07 QA80-9362 v8.0560 GET_ALL_INPUT_OUTPUT_OPERATIONS_IN_OBJ
#define		OPERINFO_USERNAME_MAX_LENGTH		120
#define		OPERINFO_COMPANY_MAX_LENGTH			120

enum {
	OPERSTATE_VALID_CLEAN		 = 0,
	OPERSTATE_VALID_DIRTY,
	OPERSTATE_INVALID,
};
struct OPERATIONINFO
{
	char	szUser[OPERINFO_USERNAME_MAX_LENGTH];	
	char	szCompany[OPERINFO_COMPANY_MAX_LENGTH];	
	double	dTime;
	DWORD	dwDuration;
	int		nState;
	int		nRecalcMode;
};
/// END GET_ALL_INPUT_OUTPUT_OPERATIONS_IN_OBJ


/// TD 8-15-05 QA70-8005 AUTO_COMPLTE_IN_CODEEDIT
#define AUTOCOMPLETE_DISPLAY_STRING_SIZE     50
struct AUTOCOMPLETE_DISPMSGDATA
{
	DWORD dwAttributes;
	LPCSTR lpcszEntry;
	char   szDisplayString[AUTOCOMPLETE_DISPLAY_STRING_SIZE];
};

/// TD 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
struct DLGSIZEINFO
{
	char szDialogName[MAXLINE];
	int width, height; // initial
	// -1, -1 to place dialog in the center of app.
	// -1, 0  to use last position, also set width=height=0 will use position only and use default size
	int top, left; 
	BOOL bStartHidden; ///Joseph 02/01/07 HIDE_DLG_WHEN_NEEDED
};
/// end DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS


/// ML 8/6/2007 RETURNING_COUNTS_OF_NEGATIVE_MISSING_ERROR_VALUES_WHEN_EXTRACTING_DATA
/** >Internal Origin Objects>DataRange
*/
struct STGETDATAOUTPUTINFO
{
    int nCountNegativeErrorValuesFound;
    int nCountZeroErrorValuesFound;
    int nCountMissingErrorValuesFound;
};
/// end RETURNING_COUNTS_OF_NEGATIVE_MISSING_ERROR_VALUES_WHEN_EXTRACTING_DATA

//---- CPY 10/22/07 QA70-0574 GET_PLOT_COLOR_FOR_GROUP_PLOT
/** >Internal Origin Objects>Graph
*/
typedef struct tagBASIC_PLOT_SETTINGS
{
	int nLineColor; // line color
	int nEdgeColor; // for symbols
	int nFillColor; // if symbol, or bar
	int nLineStyle;
	int nSymbolType;
	int nSymbolInterior;
	int nSymbolSize;
} BASIC_PLOT_SETTINGS;
//---- end GET_PLOT_COLOR_FOR_GROUP_PLOT


/// ML 10/29/2007 QA70-10599 EXTRACTING_AXIS_LIMITS_FROM_DATARANGE
struct DRPLOTTINGSCALE
{
	/////////////////////
	// Outputs:
	double			rX1;
	double			rX2;
	double			rY1;
	double			rY2;
	double			rZ1;
	double			rZ2;
};
/// end EXTRACTING_AXIS_LIMITS_FROM_DATARANGE


//---- CPY 12/24/07 QA70-10867 IMPORT_EXCEL_INTO_EXISTING_SHEET
/** >Import Export
*/
typedef struct tagXLSReadCntrl	
{
	DWORD	m_dwRXC;
	int		m_nMaxNumEmptyColumnsBeyondLastData;
}XLSReadCntrl;
//----


/// ML 3/12/2008 GETTING_CONTOURS_DATA
typedef	struct	_LINEPROPS
{
	DWORD			ocColor;
	double			rWidth;
	BYTE			byLineType;
} LINEPROPS;
/// end GETTING_CONTOURS_DATA

#define	MASK_WCB_NO_HWND		0x1000 // CPY 6/19/08, moved here from oc_sys.h as this header is included earlier then oc_sys.h
/// ML 8/7/2007 QA70-10178 RUN_PATCH_AUTOMATICALLY_FOR_CHECK_FOR_UPDATES  CPY 6/19/08 moved here from orgdll.h so we can use from OC
#define	WCB_CHECK_FOR_UPDATES			(MASK_WCB_NO_HWND + 82)
#define WCB_OPEN_TXT_FILE				(MASK_WCB_NO_HWND + 84) /// EJP 2008-06-19 v8.0888 NEW_CHKFORUPDATES_NEED_HANDLE_PATCH
		typedef	struct	_CHECKFORUPDATESCLBK
		{
			UINT		msg;
			LPCTSTR		lpcszString;
		} CHECKFORUPDATESCLBK,	*PCHECKFORUPDATESCLBK;

				// msg:
				enum {
					WCBCHCKUPDT_SETUP_PATCH_LAUNCHING				= 1,
				};
/// end RUN_PATCH_AUTOMATICALLY_FOR_CHECK_FOR_UPDATES


/// ML 12/24/2008 QA70-12660 P6 DELETING_WHOLE_SHEETS_OPERATION_INTERPLAY
enum WKBKDELWKSMODE {
	WKBKDELWKSMODE_DEFAULT				= 0,
	WKBKDELWKSMODE_CHECK_ASK,
	WKBKDELWKSMODE_DELETE_OPERS,
	WKBKDELWKSMODE_DELETE_OPERS_DATA,
};
/// end DELETING_WHOLE_SHEETS_OPERATION_INTERPLAY

/// TD ML 11-12-2009 QA80-14653 OC_ACCESS_MENU_FROM_CCMDUI
struct CmdUIInfo
{
	UINT m_nID;
	UINT m_nIndex;
	HMENU m_hMenu;
	HMENU m_hSubMenu;
};
/// end OC_ACCESS_MENU_FROM_CCMDUI


/// ML 2/5/2010 QA70-15083 SETTING_STRINGS_FROM_ADO_SPEC_CODEPAGE
typedef	struct	_OSTREADRS
{
	int			nCodePage;		// to use for string conversions;	0 - it uses the current OS code page
								//									-1 - uses the current code page Origin uses for various string
								//											manipulations(which might be different from OS code page)
								//									> 0 - the code page value to use for string conversion
} OSTREADRS, *POSTREADRS;
/// end SETTING_STRINGS_FROM_ADO_SPEC_CODEPAGE

/// Fisher 05/12/10 ORG-97 XYZ_CONTOUR_PROFILE
/// Moved from octricontour.h
#define			TRI_ADJLIST_BEG(_nTrglIndex_)			((_nTrglIndex_) * 3)
#define			TRI_TRIANGLE_BEG(_nTrglIndex_)			((_nTrglIndex_) * 6)

typedef struct{
	BOOL	bsuccess; // specifies the status of triangulation
	double *x;  // the position and the value of the scattering points
	double *y;
	double *f;
	int np;     // the number of scatter points

	// Contains the info of triangulation
	int nt; // number of triangle
	int *vTriangle; // the number of vertexes and sides of the (i)th triangle are stored in vTriangle[i*6], vTriangle[i*6+1],...,vTriangle[i*6+5].  

	int nl; // number of line
	int *vLine; // the number of vertexes of the (i)th side are in vLine[i*3], vLine[i*3+1], vLine[i*3+2] = 1 if the side is on the border. 

	int npb; // number of points on the boundary
	int *vPBorder; // indices of the sequence points on the boundary 

	/// Fisher 05/07/10 ORG-107 TRI_CONTOUR_DATA_STRUCTURE_IMPROVEMENT
	int	*vAdjList;	// the three adj triangles of the (i)th triangle are stored in vAdjList[i*3], vAdjList[i*3+1], vAdjList[i*3+2], -1 if border

}	TRIANGULATION;
/// ---------


/// Derek 6/4/2010 OPENCV_BASED_IMAGE_CODE
#ifdef		__USE_OCV_IMAGE__
typedef	void	*OHIMG;
#endif		// __USE_OCV_IMAGE__
/// end OPENCV_BASED_IMAGE_CODE



/// Hong 01/20/10 QA80-14785 IMPROVE_IMPORT_SPEED_FOR_TDM_STRING_COL
#ifdef	__cplusplus
extern "C" {
#endif	//__cplusplus

	typedef int (__stdcall *pfnDDC_GetValues)(DWORD , DWORD , DWORD , void*);
	typedef void (__stdcall *pfnDDC_FreeMemory)(void*);

#ifdef	__cplusplus
}
#endif	//__cplusplus
/// end IMPROVE_IMPORT_SPEED_FOR_TDM_STRING_COL



#endif // _OC_TYPES_H
